import os


class CliException(Exception):
    def __init__(self, message=None, exit_cli=False):
        super().__init__(message)
        self.message = message
        self.exit_cli = exit_cli


class InvalidCmdUsageException(CliException):
    def __init__(self):
        super().__init__()


def get_templates_dir_root() -> os.path:
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), 'templates')


def get_k8s_templates_dir_root() -> os.path:
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), 'templates', 'k8s-local')


def get_repository_templates_dir_root() -> os.path:
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), 'repositories')


def get_docker_compose_scripts_dir() -> os.path:
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), 'deployments', 'compose')


def get_helm_charts_dir() -> os.path:
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), 'deployments', 'helm')


def get_scripts_dir_root() -> os.path:
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), 'scripts')


def get_cli_cert_dir() -> os.path:
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), 'certs', 'cli')


def read_eula_file() -> str:
    with open(os.path.join(os.path.dirname(os.path.abspath(__file__)), 'EULA.txt'), 'r') as f:
        return f.read()
