import argparse
import configparser
import logging
import time

from rdaf.cmd import CliCmdHandler
from rdaf.contextual import COMPONENT_REGISTRY

logger = logging.getLogger(__name__)


class EdgeInstallCmdHandler(CliCmdHandler):
  
    def configure_parser(self, parser):
        parser.add_argument('--infra-tag', dest='infra_tag', action='store', required=True,
                            help='Tag to use for the docker images of the infra components')

        parser.add_argument('--platform-tag', dest='platform_tag', action='store', required=True,
                            help='Tag to use for the docker images of the platform components')

        parser.add_argument('--worker-tag', dest='worker_tag', action='store', required=True,
                            help='Tag to use for the docker images of the worker components')

    def handle(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        self.install_rda_edge(cmd_args, config_parser)

    @staticmethod
    def install_rda_edge(cmd_args, config_parser):
        infra_components = COMPONENT_REGISTRY.get_by_category('infra')
        cmd_args.tag = cmd_args.infra_tag
        for component in infra_components:
            component_name = component.get_name()
            logger.info('Installing ' + component_name)
            component.install(cmd_args, config_parser)

        time.sleep(10)
        cmd_args.tag = cmd_args.platform_tag
        cmd_args.services = None
        logger.info("Installing platform components...")
        components = COMPONENT_REGISTRY.get_by_category('platform')
        for component in components:
            component.install(cmd_args, config_parser)

        cmd_args.tag = cmd_args.worker_tag
        logger.info("Installing worker components...")
        component = COMPONENT_REGISTRY.get('rda_worker')
        component.install(cmd_args, config_parser)
        logger.info("RDA Edge deployment completed.")
        return

