import rdaf.component as comp
import configparser
import logging.config
from rdaf.contextual import COMPONENT_REGISTRY
from rdaf.cmd import CliCmdHandler
import os

logger = logging.getLogger(__name__)


class PruneImageCmdHandler(CliCmdHandler):
    def handle(self, cmd_args, config_parser: configparser.ConfigParser):
        if os.path.exists(os.path.join('/opt', 'rdaf', 'rdaf.cfg')):
            all_known_hosts = COMPONENT_REGISTRY.get_all_known_component_hosts\
            (skip_components=[comp.dockerregistry.COMPONENT_NAME])
            docker_cmd = "docker image prune -a -f"
            for host in all_known_hosts:
                logger.info('Docker prune unused images for ' + host)
                comp.execute_command_ssh(docker_cmd, host, config_parser)

class K8SPruneImageCmdHandler(CliCmdHandler):
    def handle(self, cmd_args, config_parser: configparser.ConfigParser):
        if os.path.exists(os.path.join('/opt', 'rdaf', 'rdaf.cfg')):
            nodes = comp.Component.get_k8s_nodes()
            docker_cmd = "docker image prune -a -f"
            for node in nodes:
                try:
                    comp.execute_command_ssh(docker_cmd, node, config_parser)
                    logger.info(f'Successfully pruned images on node: {node}')
                except Exception as e:
                    logger.error(f'Failed to prune images on node {node}: {str(e)}')