import os.path
import subprocess
from subprocess import check_output
from shlex import split
import json
from datetime import datetime
import traceback

pod_names = ["rda-nats-0", "rda-nats-1"]

def delete_pod(pod):
    del_cmd = f"kubectl --kubeconfig ${KUBE_CONFIG} -n rda-fabric delete pod {pod} --grace-period 0 --force"
    result = check_output(split(del_cmd))
    result = result.decode("utf-8").strip()
    f.write(f"{datetime.now()}:\t\t{pod} - Successfully deleted pod - {result}\n")

with open("${LOG_FILE}", "a") as f:
    try:
        f.write(f"{datetime.now()}: Checking {pod_names} are healthy\n")
        for pod in pod_names:
            f.write(f"{datetime.now()}: {pod} - Started processing\n")
            command = f"kubectl --kubeconfig ${KUBE_CONFIG} -n rda-fabric get events --field-selector involvedObject.name={pod} --sort-by='.metadata.creationTimestamp' -o json"
            try:
                result = check_output([command], shell=True, stderr=subprocess.STDOUT)
            except subprocess.CalledProcessError  as ex:
                f.write(f"Error while executing command: {command}. {ex.output}")
                raise
            result = result.decode("utf-8").strip()
            print("================================================")
            print(f"Command: {command}")
            print(f"Result:\n{result}")
            print("================================================")
            data = json.loads(result)
            items = data.get("items", [])
            f.write(f"{datetime.now()}:\t\t{pod} - got {len(items)} events\n")
            if items:
                last_event = items[-1]
                print(f"Last event: {last_event} {pod}")
                if last_event.get("reason") == "NodeNotReady":
                    f.write(f"{datetime.now()}:\t\t{pod} - is not ready state. Deleting it\n")
                    delete_pod(pod)
                    continue
            f.write(f"{datetime.now()}:\t\t{pod} no events. Checking get pods output\n")
            command = f"kubectl -n rda-fabric get pods {pod}"
            kubectl = subprocess.Popen(split(command), stdout=subprocess.PIPE)
            grep = subprocess.Popen(split("grep Terminating"), stdin=kubectl.stdout, stdout=subprocess.PIPE)
            result = check_output(split("awk '{print }'"), stdin=grep.stdout)
            result = result.decode('utf-8').strip()
            print("================================================")
            print(f"Command: {command}")
            print(f"Result:\n{result}")
            print("================================================")
            k8s_pods = set(result.split())
            if not k8s_pods:
                f.write(f"{datetime.now()}:\t\t{pod} - is not in terminating mode. Exiting\n")
            else:
                print(f"{pod} is in terminating mode")
                f.write(f"{datetime.now()}:\t\t{pod} - is in terminating state. Deleting it\n")
                delete_pod(pod)

    except:
        f.write(f"{datetime.now()}:\t\tException while trying to check and delete nats pods\n")
        traceback.print_exc(file=f)