import configparser

import rdaf.component.dockerregistry
import rdaf.contextual
from rdaf.cmd import CliCmdHandler


class SetDockerRegCmdHandler(CliCmdHandler):

    def configure_parser(self, parser):
        parser.add_argument('--host',
                            dest="docker_registry_host",
                            required=True,
                            action='store',
                            help='Hostname/IP of the Docker registry')
        parser.add_argument('--port',
                            dest="docker_registry_port",
                            required=True,
                            action='store',
                            default='',
                            help='Port of the Docker registry')
        parser.add_argument('--user',
                            dest="docker_registry_user",
                            required=False,
                            action='store',
                            help='Username of the Docker registry')
        parser.add_argument('--password',
                            dest="docker_registry_password",
                            required=False,
                            action='store',
                            help='Password of the Docker registry')
        parser.add_argument('--cert-path',
                            dest="cert_path",
                            required=False,
                            action='store',
                            help='path of the Docker registry ca cert')

    def handle(self, cmd_args, config_parser: configparser.ConfigParser):
        docker_reg = rdaf.contextual.COMPONENT_REGISTRY.require(
            rdaf.component.dockerregistry.COMPONENT_NAME)
        docker_reg.set_docker_registry(cmd_args, config_parser)
