import argparse
import configparser
import os

import rdaf.util.requestsutil
from rdaf.component import Component

COMPONENT_NAME = 'proxy'


class Proxy(Component):
    _option_enable = 'enable'

    def __init__(self):
        super().__init__(COMPONENT_NAME, 'proxy', 'infra')

    def _init_default_configs(self):
        default_configs = dict()
        default_configs[self._option_enable] = None
        return default_configs

    def gather_setup_inputs(self, cmd_args, config_parser):
        proxy_configs = self._init_default_configs()

        proxy_configs[self._option_enable] = 1
        self._mark_configured(proxy_configs, config_parser)

    def down(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        # nothing to do
        pass

    def up(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        # nothing to do
        pass

    def install(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        # nothing to do
        pass

    def k8s_install(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        pass

    def k8s_upgrade(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        pass
    
    def k8s_down(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        pass

    def k8s_up(self, cmd_args: argparse.Namespace, config_parser: configparser.ConfigParser):
        pass
    
    def get_container_proxy_env_vars(self, quote_special_chars=False):
        env = dict()
        # check if proxy detection is enabled
        if not int(self.configs[self._option_enable]):
            return env

        http_proxy = os.environ['http_proxy'] if 'http_proxy' in os.environ else None
        if quote_special_chars:
            http_proxy = rdaf.util.requestsutil._safe_encode_proxy_url(http_proxy)
        env['http_proxy'] = http_proxy
        https_proxy = os.environ['https_proxy'] if 'https_proxy' in os.environ else None
        if quote_special_chars:
            https_proxy = rdaf.util.requestsutil._safe_encode_proxy_url(https_proxy)
        env['https_proxy'] = https_proxy
        env['no_proxy'] = os.environ['no_proxy'] if 'no_proxy' in os.environ else None
        return env

    def is_proxy_enabled(self) -> bool:
        return True if int(self.configs[self._option_enable]) else False
