import os
import sys
from codecs import open
from os import path
from pathlib import Path

from setuptools import setup, find_packages

__dir = path.abspath(path.dirname(__file__))

long_description = ''
if not path.exists(path.join(__dir, 'README.md')):
    sys.exit("\nERROR: README.md doesnt exist.\n")
else:
    with open(path.join(__dir, 'README.md'), encoding='utf-8') as f:
        long_description = f.read()


with open(os.path.join(os.path.dirname(__file__), 'rdaf', 'version.txt'), 'r') as version_file:
    _version = version_file.readline().strip()


def glob_fix(package_name, glob):
    # this assumes setup.py lives in the folder that contains the package
    package_path = Path(f'./{package_name}').resolve()
    return [str(path.relative_to(package_path)) for path in package_path.glob(glob)]


_package_data = ['version.txt', 'EULA.txt', 'logrdaf.ini', 'repositories/*', 'certs/**/*',
                 'certs/*', 'scripts/*', 'templates/**/*', 'templates/*',
                 *glob_fix('rdaf', 'deployments/**/*')]

setup(
    name='rdafcli',
    packages=find_packages(exclude=['docs', 'tests']),
    version=_version,
    description='CLI tool for managing RDAF platform installations',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='cloudfabrix.com',
    author='cloudfabrix.com',
    author_email='support@cloudfabrix.com',
    keywords='rdaf',
    install_requires=['docker==7.1.0',
                      'paramiko==3.5.1',
                      'PrettyTable==3.11.0',
                      'requests==2.32.3',
                      'termcolor==2.4.0',
                      'dnspython==2.6.1',
                      'netifaces==0.11.0',
                      'psutil==6.0.0',
                      'python-dateutil==2.9.0',
                      'scp==0.15.0',
                      'PyYAML==6.0.2',
                      'distro==1.9.0',
                      'pyOpenSSL==24.3.0',
                      'PyJWT==2.9.0',
                      'cryptography==44.0.1',
                      'urllib3==2.2.2',
                      'nats-python==0.8.0',
                      'six==1.16.0',
                      'setuptools==74.1.1',
                      'kafka-python-ng==2.2.2'
                      ],
    package_data={'rdaf': _package_data},
    entry_points={
        'console_scripts': ['rdaf=rdaf.rdafcli:main',
                            'rdafk8s=rdaf.rdafcli:k8s_main'],
    }
)
