import subprocess
import pkg_resources
import os


def test_help_command():
    r"""
    Tests that the "rdaf --help" command works fine
    """
    # make sure the CLI command exited without errors
    output = subprocess.check_output(["radf", "--help"])
    # Do some basic test that the output of the command contains some expected data
    assert b"setup" in output
    assert b"status" in output


def test_version_command():
    r"""
    Tests that the "rdaf --version" command prints the correct output
    """
    expected_version = "RDAF CLI version: " + pkg_resources.require('rdafcli')[0].version\
                       + os.linesep
    output = subprocess.check_output(["rdaf", "--version"])
    assert expected_version == str(output, encoding='utf-8')


def test_debug_flag():
    r"""
    Tests that the --debug flag when passed to the rdaf command, doesn't
    generate any unexpected errors
    """
    try:
        # TODO: use a simpler/better command to test --debug option
        subprocess.check_output(["rdaf", "setup", "--debug", "dummy"],
                                stderr=subprocess.STDOUT)
    except subprocess.CalledProcessError as e:
        # expected
        None

